-------------------------------------------------------------- 
--                                                          --
--    Copyright 1993 Altera Corporation                     --
--    VHDL example for macrocell instantiation              --
--    Description : 16 bit adder. Example for macro cell    --
--                  instantiation.                          --
--                                                          --
--------------------------------------------------------------
library synth;
use synth.stdsynth.all;
--Remove all the comments below this line when using Vantage analyzer
--library pack1076;
--use pack1076.pack1076.all;
--library alt_mf;
--use alt_mf.all;

ENTITY ADDER16_EX IS
	PORT (a, b : IN VLBIT_VECTOR(15 DOWNTO 0);
	      ci   : IN VLBIT;
	      sum  : OUT VLBIT_VECTOR(15 DOWNTO 0);
	      co   : OUT VLBIT);
END ADDER16_EX;

ARCHITECTURE behavior OF ADDER16_EX IS
	signal low_co: VLBIT;

   component A_8FADD
        port (A8, A7, A6, A5, A4, A3, A2, A1 : in VLBIT;
              B8, B7, B6, B5, B4, B3, B2, B1 : in VLBIT;
              CIN : in VLBIT;
              SUM8, SUM7, SUM6, SUM5, SUM4, SUM3, SUM2, SUM1, COUT : out VLBIT);
  
   end component;

--for all : a_8fadd use entity alt_mf.a_8fadd (behavior);

BEGIN

	u1: a_8fadd 
	PORT MAP ( a8=>a(7), a7=>a(6), a6=>a(5), a5=>a(4),
		   a4=>a(3), a3=>a(2), a2=>a(1), a1=>a(0),
	           b8=>b(7), b7=>b(6), b6=>b(5), b5=>b(4),
		   b4=>b(3), b3=>b(2), b2=>b(1), b1=>b(0),
		   cin=>ci,
	           sum8=>sum(7), sum7=>sum(6), sum6=>sum(5), sum5=>sum(4),
		   sum4=>sum(3), sum3=>sum(2), sum2=>sum(1), sum1=>sum(0),
		   cout=>low_co);

	u2: a_8fadd 
	PORT MAP ( a8=>a(15), a7=>a(14), a6=>a(13), a5=>a(12),
		   a4=>a(11), a3=>a(10), a2=>a(9), a1=>a(8),
	           b8=>b(15), b7=>b(14), b6=>b(13), b5=>b(12),
		   b4=>b(11), b3=>b(10), b2=>b(9), b1=>b(8),
		   cin=>low_co,
	           sum8=>sum(15), sum7=>sum(14), sum6=>sum(13), sum5=>sum(12),
		   sum4=>sum(11), sum3=>sum(10), sum2=>sum(9), sum1=>sum(8),
		   cout=>co );
END behavior;

